require( "scripts/style.lua" );






NameFont = {
  standardFont,
  22,
  BlackColor
};

SelectFont = {
  standardFont,
  36,
  BlackColor
};

HeaderFont = {
  standardFont,
  48,
  BlackColor
};

ButtonX = kCenter;
ButtonY = 100;
ButtonYSpace = 33;


NameButtonGraphics = {
	"",
	"buttons/choosenamedown.png",
	"",
	"buttons/choosenamedown.png"
};	

NameStyle= {
	type = kRadio,
	flags = kHAlignCenter + kVAlignCenter,
	font = NameFont,
	graphics = NameButtonGraphics,
	sound = kDefaultButtonSound
};

UpButtonGraphics = {
	"buttons/arrowup_up.png",
	"buttons/arrowup_down.png",
	"buttons/arrowup_over.png"
};

DownButtonGraphics = {
	"buttons/arrowdown_up.png",
	"buttons/arrowdown_down.png",
	"buttons/arrowdown_over.png"
};

MakeDialog
{
	Bitmap
	{ 
		image="backgrounds/talldialog",
		x=kCenter,
		y=kCenter,
		
		ChoosePlayerWindow
		{
			x = 0, y = 0, w=kMax, h=kMax,
			
			Text
			{
				font = SelectFont,
				name = "selectaplayer",
				x=kCenter,y=66,w=kMax,h=kMax,
				flags = kHAlignCenter + kVAlignTop,
				label = "selectaplayer"
			};

			--[[Button
			{
				font = StandardButtonFont,
				graphics = UpButtonGraphics,
				name="scrollup",
				label="",
				type = kPush,
				rolloversound = "assets/audio/sfx/dialog_roll.ogg",
				sound = "assets/audio/sfx/dialog_click.ogg",
				x=550,
				y=140,
			};
			
			Button
			{
				font = StandardButtonFont,
				graphics = DownButtonGraphics,
				name="scrolldown",
				label="",
				type = kPush,
				rolloversound = "assets/audio/sfx/dialog_roll.ogg",
				sound = "assets/audio/sfx/dialog_click.ogg",
				x=550,
				y=400,
			};]]--

			SetStyle(NameStyle);
			BeginGroup();
			Button{
				name="button0",
				label="name",
				x=ButtonX,
				y=ButtonY+(ButtonYSpace*0),
				rolloversound = "assets/audio/sfx/dialog_roll.ogg",
				sound = "assets/audio/sfx/dialog_click.ogg",
			};
			
			Button{
				name="button1",
				label="name",
				x=ButtonX,
				y=ButtonY+(ButtonYSpace*1),
				rolloversound = "assets/audio/sfx/dialog_roll.ogg",
				sound = "assets/audio/sfx/dialog_click.ogg",
			};
			
			Button{
				name="button2",
				label="name",
				x=ButtonX,
				y=ButtonY+(ButtonYSpace*2),
				rolloversound = "assets/audio/sfx/dialog_roll.ogg",
				sound = "assets/audio/sfx/dialog_click.ogg",
			};
			
			Button{
				name="button3",
				label="name",
				x=ButtonX,
				y=ButtonY+(ButtonYSpace*3),
				rolloversound = "assets/audio/sfx/dialog_roll.ogg",
				sound = "assets/audio/sfx/dialog_click.ogg",
			};
			
			Button{
				name="button4",
				label="name",
				x=ButtonX,
				y=ButtonY+(ButtonYSpace*4),
				rolloversound = "assets/audio/sfx/dialog_roll.ogg",
				sound = "assets/audio/sfx/dialog_click.ogg",
			};
			
			Button{
				name="button5",
				label="name",
				x=ButtonX,
				y=ButtonY+(ButtonYSpace*5),
				rolloversound = "assets/audio/sfx/dialog_roll.ogg",
				sound = "assets/audio/sfx/dialog_click.ogg",
			};
			Button{
				name="button6",
				label="name",
				x=ButtonX,
				y=ButtonY+(ButtonYSpace*6),
				rolloversound = "assets/audio/sfx/dialog_roll.ogg",
				sound = "assets/audio/sfx/dialog_click.ogg",
			};
			Button{
				name="button7",
				label="name",
				x=ButtonX,
				y=ButtonY+(ButtonYSpace*7),
				rolloversound = "assets/audio/sfx/dialog_roll.ogg",
				sound = "assets/audio/sfx/dialog_click.ogg",
			};
			Button{
				name="button8",
				label="name",
				x=ButtonX,
				y=ButtonY+(ButtonYSpace*8),
				rolloversound = "assets/audio/sfx/dialog_roll.ogg",
				sound = "assets/audio/sfx/dialog_click.ogg",
			};
			Button{
				name="button9",
				label="name",
				x=ButtonX,
				y=ButtonY+(ButtonYSpace*9),
				rolloversound = "assets/audio/sfx/dialog_roll.ogg",
				sound = "assets/audio/sfx/dialog_click.ogg",
			};
			
			SetStyle(DefaultStyle);
							
			Button{
				x=kCenter-80,
				y=445,
				font = StandardButtonFont,
				graphics = LongButtonGraphics,
				name="editname",
				label="",
				type = kPush,
				label="editname",
				rolloversound = "assets/audio/sfx/dialog_roll.ogg",
				sound = "assets/audio/sfx/dialog_click.ogg",
				command =
					function()
						gEnterNameValue = GetSelectedPlayerName();
						name = DoModal("scripts/entername.lua");
						if (not(name == nil)) then
							ChangeCurrentUserName(name);
							SetPlayerChoices();
							SetWelcomeName();
						end
					end
			};
			
			Button{
				x=kCenter+80,
				y=445,
				font = StandardButtonFont,
				graphics = LongButtonGraphics,
				name="newplayer",
				label="newplayer",
				type = kPush,
				rolloversound = "assets/audio/sfx/dialog_roll.ogg",
				sound = "assets/audio/sfx/dialog_click.ogg",
				command =
					function()
						gEnterNameValue = "";
						name = DoModal("scripts/entername.lua");
						if (not(name == nil)) then
							CreateNewUser(name);
							SetPlayerChoices()
						end
					end
			};
			
				
			Button{
				x=kCenter-80,
				y=488,
				font = StandardButtonFont,
				graphics = LongButtonGraphics,
				name="delete",
				label="deleteplayer",
				type = kPush,
				rolloversound = "assets/audio/sfx/dialog_roll.ogg",
				sound = "assets/audio/sfx/dialog_click.ogg",
				command =
					function()
						result = DisplayDialog { 
							"scripts/yesno.lua", 
							body ="deleteconfirm",
							title = "deletetitle" 
						};
						if (result=='yes') then
							userNum = GetCurrentSelectedUser();
							DeleteUser(userNum)
							SetPlayerChoices()
							if(GetNumUsers() == 0) then 
							    PopModal();
							    DoModal("scripts/chooseplayer.lua"); 
							end
						end
					end
				
			};
			
			Button{
				x=kCenter+80,
				y=488,
				font = StandardButtonFont,
				graphics = LongButtonGraphics,
				name="chooseok",
				label="ok",
				type = kPush,
				rolloversound = "assets/audio/sfx/dialog_roll.ogg",
				sound = "assets/audio/sfx/dialog_click.ogg",
				command = 
					function()
						userNum = GetCurrentSelectedUser();
						SetCurrentUser(userNum);
						SetWelcomeName();
						PopModal();
					end
				
			};
		}
	}
}

SetPlayerChoices();



